// Study of Outdoor Propagation – Hata Model
// OS: Windows 10
// Scilab: 6.1.0
// Course Instructor: Dr. V. A. Sankar Ponnapalli
// Institute: ICFAI Foundation for Higher Education Hyderabad

clc;
clear;
close;

disp("Enter Transmitter Height in meters (Valid range: 30–200 m):");
ht = input("Transmitter Height (m): ");

disp("Enter Receiver Height in meters (Valid range: 1–10 m):");
hr = input("Receiver Height (m): ");

disp("Enter Distance between Tx–Rx in km (Valid range: 1–20 km):");
d = input("Distance (km): ");

f_values = [150, 300, 600, 900, 1200, 1500];  // in MHz

Lp_small = zeros(1, length(f_values));  // Path loss for small/medium cities
Lp_large = zeros(1, length(f_values));  // Path loss for large cities

// ---------------- HATA MODEL CALCULATION ----------------

for i = 1:length(f_values)
    f = f_values(i);

    // Correction factor for small/medium cities
    ah_small = (1.1 * log10(f) - 0.7) * hr - (1.56 * log10(f) - 0.8);

    // Correction factor for large cities
    if f <= 200 then
        ah_large = 8.29 * (log10(1.54 * hr))^2 - 1.1;
    else
        ah_large = 3.2 * (log10(11.75 * hr))^2 - 4.97;
    end

    // Path Loss Calculations
    Lp_small(i) = 69.55 + 26.16 * log10(f) - 13.82 * log10(ht) - ah_small + (44.9 - 6.55 * log10(ht)) * log10(d);
    Lp_large(i) = 69.55 + 26.16 * log10(f) - 13.82 * log10(ht) - ah_large + (44.9 - 6.55 * log10(ht)) * log10(d);
end

scf(0);
plot(f_values, Lp_small, 'b-o', "LineWidth", 2);
plot(f_values, Lp_large, 'r-s', "LineWidth", 2);

xlabel("Frequency (MHz)");
ylabel("Path Loss (dB)");
title("Hata Model: Path Loss vs Frequency (Urban Cities)");
legend("Small/Medium City", "Large City", "location", "upper_left");
xgrid();

// Description of the Figure
// User Inputs:
// "Enter Transmitter Height in meters (Valid range: 30–200 m):"
// Transmitter Height (m): 50
// "Enter Receiver Height in meters (Valid range: 1–10 m):"
// Receiver Height (m): 3
// "Enter Distance between Tx–Rx in km (Valid range: 1–20 km):"
// Distance (km): 10
// The figure titled "Hata Model: Path Loss vs Frequency (Urban Cities)" illustrates the variation of path loss with frequency for urban environments using the Hata propagation model.
// It compares path loss in two types of urban areas.
